//
//  BIInvoiceCard.h
//  BIViews
//
//  Created by Eric Hochmeister on 12/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MCApplication/MCWindowController.h>

@class BIInvoice;
@class BIClient;
@class BITimeSlip;
@class MCTVToolbarView;

@interface BIInvoiceCard : MCWindowController {

//	IBOutlet NSButton* cancelButton;
	IBOutlet NSButton* showInvoicePDF;

//	BOOL _createInvoiceFlag;

	BIInvoice* _invoice;
	BIClient* _client;
    	
	IBOutlet NSTextField* invoiceTitleField;
	IBOutlet NSTextField* numSlipsInInvoiceField;
    IBOutlet NSArrayController* slipsController;
    IBOutlet NSTableView* slipsTableView;
    IBOutlet MCTVToolbarView* slipsTVToolbar;
    IBOutlet NSPopUpButton* statePopUpButton;
	IBOutlet NSTabView *tabView;
	
	IBOutlet NSNumberFormatter *currencyFormatter;
}

- (BIInvoice *)invoice;
- (void)setInvoice:(BIInvoice *)anInvoice;
- (BIClient *)client;
- (void)setClient:(BIClient *)aClient;

- (void)setupInvoiceCardWithInvoice:(BIInvoice*)anInvoice;


//- (IBAction)cancel:(id)sender;
//- (IBAction)saveInvoice:(id)sender;
- (IBAction)closeInvoice:(id)sender;

- (IBAction)openInvoicePDF:(id)sender;
- (IBAction)emailInvoicePDF:(id)sender;
- (IBAction)exportSlip:(id)sender;

- (NSString*)invoiceTitleString;

- (NSString*)invoiceCommentaryString;

- (BOOL)canEditSlip;
- (void)setupSlipsTVToolbar;

- (void)showSlip:(BITimeSlip *)aSlip;


@end
